from __future__ import unicode_literals

from django.db import models

from oficinas.models import Oficinas

# Archivo: models.py
# Fecha de modificación: 2025/10/12 19:51:47
# Autor: InterWebGdl
# Version: 1.0
# Sitio web: https://interwebgdl.com
# Contacto: sgcarlos@interwebgdl.com


# *** Modelos para la aplicacion 'Clientes' ***
class CliEstatus(models.Model):
    cli_estatus_id = models.AutoField(primary_key=True,db_column="Cli_Estatus_Id")
    nombre = models.CharField(max_length=145,db_column="Nombre")

    class Meta:
        db_table = "cli_estatus"


class Clientes(models.Model):
    cli_id = models.AutoField(db_column='Cli_Id', primary_key=True)  # Field name made lowercase.
    cli_num_cliente = models.CharField(db_column="Cli_Num_Cliente",max_length=30)
    cli_nombre_cliente = models.CharField(db_column="Cli_Nombre_Cliente",max_length=400)


    #cli_giro_empresa = models.CharField(db_column='Cli_Giro_Empresa', max_length=200, blank=True, null=True)  # Field name made lowercase.


    cli_logo_empresa = models.CharField(db_column='Cli_Logo_Empresa', max_length=200, blank=True, null=True)  # Field name made lowercase.
    cli_tipo_persona = models.CharField(db_column="Cli_Tipo_Persona",max_length=50)


    #cli_nombre_empresa = models.CharField(db_column='Cli_Nombre_Empresa', max_length=200, blank=True, null=True)  # Field name made lowercase.
    #cli_razon_social = models.CharField(db_column='Cli_Razon_Social', max_length=200, blank=True, null=True)  # Field name made lowercase.
    #cli_rfc_empresa = models.CharField(db_column='Cli_Rfc_Empresa', max_length=13, blank=True, null=True)  # Field name made lowercase.


    cli_contacto_empresa = models.CharField(db_column='Cli_Contacto_Empresa', max_length=200, blank=True, null=True)  # Field name made lowercase.
    cli_telefono_contacto = models.CharField(db_column='Cli_Telefono_Contacto', max_length=100, blank=True, null=True)  # Field name made lowercase.
    cli_correo_contacto = models.CharField(db_column='Cli_Correo_Contacto', max_length=50, blank=True, null=True)  # Field name made lowercase.
    cli_puesto_contacto = models.CharField(db_column='Cli_Puesto_Contacto', max_length=200, blank=True, null=True)  # Field name made lowercase.
    cli_domicilio_empresa = models.CharField(db_column='Cli_Domicilio_Empresa', max_length=300, blank=True, null=True)  # Field name made lowercase.
    cli_num_colaboradores = models.IntegerField(db_column='Cli_Num_Colaboradores', blank=True, null=True)  # Field name made lowercase.


    #cli_fecha_contrato = models.DateField(db_column='Cli_Fecha_Contrato', blank=True, null=True)  # Field name made lowercase.
    #cli_oficina = models.ForeignKey(Oficinas,models.CASCADE,db_column='Cli_Oficina', max_length=120)  # Field name made lowercase.


    cli_estatus = models.ForeignKey(to=CliEstatus,on_delete=models.DO_NOTHING,db_column="Cli_Estatus",default=1)
    cli_contrato = models.CharField(db_column="Cli_Contrato",null=True,max_length=200)
    cli_motivo_baja = models.CharField(db_column="Cli_Motivo_Baja",null=True,max_length=1000)
    cli_municipio = models.CharField(max_length=1000,db_column="Cli_Municipio")
    cli_estado = models.CharField(max_length=100,db_column="Cli_Estado")
    cli_codigo_postal = models.CharField(max_length=45,db_column="Cli_Codigo_Postal")
    cli_fecha_baja = models.DateField(db_column="Cli_Fecha_Baja")
    cli_motivo_lista_negra = models.CharField(max_length=100)
    cli_fecha_lista_negra = models.DateField()

    cli_datos_acta_constitutiva = models.ForeignKey(to="clientes.DatosActaConstitutiva",on_delete=models.DO_NOTHING, related_name="cliente")


    #cli_datos_facturacion_cliente = models.ForeignKey(to="clientes.DatosFacturacionCliente",on_delete=models.DO_NOTHING, related_name="cliente")


    cli_datos_fiscales_persona_fisica = models.ForeignKey(to="clientes.DatosFiscalesPersonaFisica",on_delete=models.DO_NOTHING, related_name="cliente")
    cli_datos_fiscales_persona_moral = models.ForeignKey(to="clientes.DatosFiscalesPersonaMoral",on_delete=models.DO_NOTHING, related_name="cliente")
    cli_datos_persona_fisica = models.ForeignKey(to="clientes.DatosPersonaFisica",on_delete=models.DO_NOTHING, related_name="cliente")
    cli_datos_persona_moral = models.ForeignKey(to="clientes.DatosPersonaMoral",on_delete=models.DO_NOTHING, related_name="cliente")
    cli_datos_poder_representante_legal = models.ForeignKey(to="clientes.DatosPoderRepresentanteLegal",on_delete=models.DO_NOTHING, related_name="cliente")
    #cli_informacion_contrato = models.ForeignKey(to="clientes.InformacionContrato",on_delete=models.DO_NOTHING, related_name="cliente")
    cli_informacion_contrato_id = models.IntegerField()

    # Fecha y hora de creacion
    cli_fecha_registro = models.DateTimeField(auto_now_add=True)
    # Fecha y hora de modificación
    cli_fecha_modificacion = models.DateTimeField(auto_now=True)

    def tiene_datos_acta_constitutiva(self):
        tiene_acta_constitutiva = False
        try:
            tiene_acta_constitutiva = self.cli_datos_acta_constitutiva is not None
        except:
            pass
        return tiene_acta_constitutiva

    """
def tiene_datos_facturacion_cliente(self):
tiene_datos_facturacion_cliente = False
try:
tiene_datos_facturacion_cliente = self.cli_datos_facturacion_cliente is not None
except:
pass
return tiene_datos_facturacion_cliente
"""


    def tiene_datos_fiscales_persona_fisica(self):
        tiene_datos_fiscales_p_fisica = False
        try:
            tiene_datos_fiscales_p_fisica = self.cli_datos_fiscales_persona_fisica is not None
        except:
            pass
        return tiene_datos_fiscales_p_fisica

    def tiene_datos_fiscales_persona_moral(self):
        tiene_datos_fiscales_p_moral = False
        try:
            tiene_datos_fiscales_p_moral = self.cli_datos_fiscales_persona_moral is not None
        except:
            pass
        return tiene_datos_fiscales_p_moral

    def tiene_datos_persona_fisica(self):
        tiene_datos_persona_fisica = False
        try:
            tiene_datos_persona_fisica = self.cli_datos_persona_fisica is not None
        except:
            pass
        return tiene_datos_persona_fisica

    def tiene_datos_persona_moral(self):
        tiene_datos_persona_moral = False
        try:
            tiene_datos_persona_moral = self.cli_datos_persona_moral is not None
        except:
            pass
        return tiene_datos_persona_moral

    def tiene_datos_poder_representante_legal(self):
        tiene_datos_poder_representante_legal = False
        try:
            tiene_datos_poder_representante_legal = self.cli_datos_poder_representante_legal is not None
        except:
            pass
        return tiene_datos_poder_representante_legal

    def tiene_informacion_contrato(self):
        tiene_informacion_contrato = False
        try:
            tiene_informacion_contrato = self.cli_informacion_contrato is not None
        except:
            pass
        return tiene_informacion_contrato






    class Meta:
        db_table = 'clientes'

class RolCliente(models.Model):
    rol_cliente_id = models.AutoField(primary_key=True)
    nombre = models.CharField(max_length=100)

    class Meta:
        db_table = 'roles_cliente'

class ContactoCliente(models.Model):
    contacto_cliente_id = models.AutoField(primary_key=True)
    nombre = models.CharField(max_length=100)
    puesto = models.CharField(max_length=100)
    celular = models.CharField(max_length=25)
    correo = models.CharField(max_length=150)
    cliente = models.ForeignKey(to=Clientes,on_delete=models.DO_NOTHING)

    class Meta:
        db_table = "contactos_cliente"

class PuestoCliente(models.Model):
    puesto_cliente_id = models.AutoField(primary_key=True)
    nombre = models.CharField(max_length=100)

    class Meta:
        db_table = "puestos_cliente"

class OficinaPuestoCliente(models.Model):
    oficina_puesto_cliente_id = models.AutoField(primary_key=True)
    oficina = models.ForeignKey(to=Oficinas,on_delete=models.DO_NOTHING)
    puesto_cliente = models.ForeignKey(to=PuestoCliente,on_delete=models.DO_NOTHING)

    class Meta:
        db_table = "oficinas_puestos_cliente"

class Sucursales(models.Model):
    surc_id = models.AutoField(db_column='Surc_Id', primary_key=True)  # Field name made lowercase.
    surc_nombre = models.CharField(db_column='Surc_Nombre', max_length=200, db_collation='utf8mb3_general_ci')  # Field name made lowercase.
    surc_cliente = models.ForeignKey(Clientes, models.DO_NOTHING, db_column='Surc_Cliente_id', blank=True, null=True)  # Field name made lowercase.

    class Meta:
        db_table = 'sucursales'


class Giros(models.Model):
    giro_id = models.AutoField(db_column='Giro_Id', primary_key=True)  # Field name made lowercase.
    giro_nombre = models.CharField(db_column='Giro_Nombre', max_length=200, db_collation='utf8mb3_general_ci')  # Field name made lowercase.

    class Meta:
        db_table = 'giros'

class CuentaCliente(models.Model):
    cuenta_cliente_id = models.AutoField(primary_key=True)
    correo = models.CharField(max_length=120)
    contrasenia = models.CharField(max_length=220)
    rol_cliente = models.ForeignKey(to=RolCliente,on_delete=models.DO_NOTHING)
    cliente = models.ForeignKey(to=Clientes,on_delete=models.DO_NOTHING)
    sucursal = models.ForeignKey(to=Sucursales,on_delete=models.DO_NOTHING)
    fecha_registro = models.DateTimeField(auto_now_add=True)
    fecha_modificacion = models.DateTimeField(auto_now=True)
    
    def tiene_sucursal(self):
        tiene_sucursal = False
        try:
            tiene_sucursal = self.sucursal is not None
        except:
            pass
        return tiene_sucursal

    class Meta:
        db_table = "cuentas_cliente"

class ContratosClientes(models.Model):
    con_cli_id = models.AutoField(db_column="Con_Cli_Id",primary_key=True)
    con_cli_cliente_id = models.ForeignKey(Clientes,models.DO_NOTHING,db_column="Con_Cli_Cliente_Id")
    con_cli_contrato = models.CharField(db_column="Con_Cli_Contrato",max_length=300,db_collation='utf8mb3_general_ci')
    con_cli_contrato_nombre = models.CharField(db_column="Con_Cli_Contrato_Nombre",max_length=245,db_collation='utf8mb3_general_ci')
    con_cli_contrato_type = models.CharField(db_column="Con_Cli_Contrato_Type",max_length=45)

    class Meta:
        db_table= "contratos_clientes"

class OficinaCliente(models.Model):
    oficina_cliente_id = models.AutoField(primary_key=True)
    oficina = models.ForeignKey(to=Oficinas,on_delete=models.DO_NOTHING)
    cliente = models.ForeignKey(to=Clientes,on_delete=models.DO_NOTHING)

    class Meta:
        db_table = "oficinas_cliente"

class TipoDocCli(models.Model):
    tipo_doc_cli_id = models.AutoField(primary_key=True)
    codigo = models.CharField(max_length=65)
    nombre_tipo_documento = models.CharField(max_length=100)
    nombre_carpeta = models.CharField(max_length=100)
    tipo_persona = models.CharField(max_length=30)
    grupo = models.CharField(max_length=100)

    class Meta:
        db_table = "tipo_docs_cli"

class RegistroDocCli(models.Model):
    registro_doc_cli_id = models.AutoField(primary_key=True)
    tipo_doc_cli = models.ForeignKey(to=TipoDocCli,on_delete=models.CASCADE)
    cli = models.ForeignKey(to=Clientes,on_delete=models.DO_NOTHING)
    ruta_archivo = models.CharField(max_length=545)
    fecha_carga = models.DateTimeField(auto_now_add=True)
    vigencia = models.DateField()
    observaciones = models.CharField(max_length=1000)
    no_aplica = models.BooleanField(default=False)

    class Meta:
        db_table = "registros_docs_cli"



class DatosActaConstitutiva(models.Model):
    datos_acta_constitutiva_id = models.AutoField(primary_key=True)
    numero_escritura = models.CharField(max_length=100)
    fecha = models.DateField(blank=True, null=True)
    nombre_notario = models.CharField(max_length=100)
    libro = models.CharField(max_length=200)
    folio = models.CharField(max_length=100)
    numero_notaria = models.CharField(max_length=100)
    municipio = models.CharField(max_length=100)
    estado = models.CharField(max_length=100)

    class Meta:
        db_table = 'datos_acta_constitutiva'

"""
class DatosFacturacionCliente(models.Model):
datos_facturacion_cliente_id = models.AutoField(primary_key=True)
rfc = models.CharField(max_length=20)
razon_social = models.CharField(max_length=100)
domicilio = models.CharField(max_length=200)
correo = models.CharField(max_length=100)

class Meta:
db_table = 'datos_facturacion_cliente'
"""



class DatosFiscalesPersonaFisica(models.Model):
    datos_fiscales_persona_fisica_id = models.AutoField(primary_key=True)
    rfc = models.CharField(max_length=20)
    calle_numero_fiscal = models.CharField(max_length=300)
    codigo_postal_fiscal = models.CharField(max_length=10)
    colonia_fiscal = models.CharField(max_length=100)
    municipio_fiscal = models.CharField(max_length=100)
    entidad_federativa_fiscal = models.CharField(max_length=100)
    razon_social = models.CharField(max_length=150)
    regimen_fiscal = models.CharField(max_length=100)
    #uso_cfdi = models.CharField(max_length=150)
    correo_facturacion = models.CharField(max_length=120)

    class Meta:
        db_table = 'datos_fiscales_persona_fisica'


class DatosFiscalesPersonaMoral(models.Model):
    datos_fiscales_persona_moral_id = models.AutoField(primary_key=True)
    rfc = models.CharField(max_length=20)
    calle_numero_fiscal = models.CharField(max_length=300)
    codigo_postal_fiscal = models.CharField(max_length=10)
    colonia_fiscal = models.CharField(max_length=100)
    municipio_fiscal = models.CharField(max_length=100)
    entidad_federativa_fiscal = models.CharField(max_length=100)
    regimen_fiscal = models.CharField(max_length=100)
    #uso_cfdi = models.CharField(max_length=150)
    correo_facturacion = models.CharField(max_length=120)

    class Meta:
        db_table = 'datos_fiscales_persona_moral'


class DatosPersonaFisica(models.Model):
    datos_persona_fisica_id = models.AutoField(primary_key=True)
    primer_nombre = models.CharField(max_length=100)
    segundo_nombre = models.CharField(max_length=100, db_collation='armscii8_bin')
    apellido_paterno = models.CharField(max_length=100)
    apellido_materno = models.CharField(max_length=100)
    nombre_comercial = models.CharField(max_length=150)
    fecha_nacimiento = models.DateField(blank=True, null=True)
    celular_particular = models.CharField(max_length=40)
    giro = models.CharField(max_length=100)
    curp = models.CharField(max_length=22)
    correo_personal = models.CharField(max_length=100)
    calle_numero = models.CharField(max_length=300)
    codigo_postal = models.CharField(max_length=10)
    colonia = models.CharField(max_length=100)
    municipio = models.CharField(max_length=100)
    entidad_federativa = models.CharField(max_length=100)
    puesto_cliente = models.ForeignKey(PuestoCliente, models.DO_NOTHING, blank=True, null=True)

    def tiene_puesto(self):
        tiene_puesto = False
        try:
            tiene_puesto = self.puesto_cliente is not None
        except:
            pass
        return tiene_puesto

    class Meta:
        db_table = 'datos_persona_fisica'


class DatosPersonaMoral(models.Model):
    datos_persona_moral_id = models.AutoField(primary_key=True)
    rfc_persona_moral = models.CharField(max_length=20)
    giro = models.CharField(max_length=100)
    #nombre_empresa = models.CharField(max_length=100)
    nombre_comercial = models.CharField(max_length=100)
    razon_social = models.CharField(max_length=100)
    calle_numero = models.CharField(max_length=300)
    codigo_postal = models.CharField(max_length=10)
    colonia = models.CharField(max_length=100)
    municipio = models.CharField(max_length=100)
    entidad_federativa = models.CharField(max_length=100)

    class Meta:
        db_table = 'datos_persona_moral'


class DatosPoderRepresentanteLegal(models.Model):
    datos_poder_representante_legal_id = models.AutoField(primary_key=True)
    numero_escritura = models.CharField(max_length=100)
    fecha = models.DateField(blank=True, null=True)
    nombre_notario = models.CharField(max_length=100)
    libro = models.CharField(max_length=200)
    folio = models.CharField(max_length=100)
    numero_notaria = models.CharField(max_length=100)
    municipio = models.CharField(max_length=100)
    estado = models.CharField(max_length=100)

    class Meta:
        db_table = 'datos_poder_representante_legal'

class ServicioCliente(models.Model):
    servicio_cliente_id = models.AutoField(primary_key=True)
    nombre = models.CharField(max_length=100)

    class Meta:
        db_table = "servicios_cliente"


class InformacionContrato(models.Model):
    informacion_contrato_id = models.AutoField(primary_key=True)
    oficina = models.ForeignKey(Oficinas, models.DO_NOTHING)
    numero_contrato = models.CharField(max_length=50)
    fecha_contrato = models.DateField(blank=True, null=True)
    vigencia_contrato = models.DateField(blank=True, null=True)
    servicio_producto = models.ForeignKey(to=ServicioCliente,on_delete=models.DO_NOTHING)
    contacto = models.CharField(max_length=120)
    puesto = models.CharField(max_length=150)
    sucursal = models.ForeignKey(Sucursales,models.DO_NOTHING)
    #cliente = models.ForeignKey(Clientes,models.DO_NOTHING)
    cliente = models.OneToOneField(Clientes,models.DO_NOTHING)

    def tiene_oficina(self):
        tiene_oficina = False
        try:
            tiene_oficina = self.oficina is not None
        except:
            pass
        return tiene_oficina

    def tiene_sucursal(self):
        tiene_sucursal = False
        try:
            tiene_sucursal = self.sucursal is not None
        except:
            pass
        return tiene_sucursal

    class Meta:
        db_table = 'informacion_contratos'

class ArchivoInformacionContrato(models.Model):
    archivo_informacion_contrato_id = models.AutoField(primary_key=True)
    ruta = models.CharField(max_length=600)
    nombre = models.CharField(max_length=600)
    #observaciones = models.CharField(max_length=300)
    #fecha_vigencia = models.DateField()
    fecha_carga = models.DateTimeField(auto_now_add=True)
    #no_aplica = models.BooleanField()
    informacion_contrato = models.ForeignKey(to=InformacionContrato,on_delete=models.DO_NOTHING)

    class Meta:
        db_table = "archivos_informacion_contratos"

class ArchivoAnexoInformacionContrato(models.Model):
    archivo_anexo_informacion_contrato_id = models.AutoField(primary_key=True)
    ruta = models.CharField(max_length=300)
    nombre = models.CharField(max_length=300)
    informacion_contrato = models.ForeignKey(to=InformacionContrato,on_delete=models.DO_NOTHING)
    fecha_carga = models.DateTimeField(auto_now_add=True)

    class Meta:
        db_table = "archivos_anexos_informacion_contratos"





