from django.db import models

from clientes.models import Clientes, Sucursales
from oficinas.models import Oficinas
from puestos.models import Puestos
from usuarios.models import Usuario

# Archivo: models.py
# Fecha de modificaci��n: 2023/11/03 19:50:42
# Autor: InterWebGdl
# Version: 1.0
# Sitio web: https://interwebgdl.com
# Contacto: sgcarlos@interwebgdl.com

# ** Modelos para la aplicaci��n 'colaboradores' ***


class ColDatosEmergencia(models.Model):
    col_dat_eme_id = models.AutoField(db_column="Col_Dat_Eme_Id",primary_key=True)
    col_dat_eme_nombre = models.CharField(db_column="Col_Dat_Eme_Nombre",max_length=145)
    col_dat_eme_celular = models.CharField(db_column="Col_Dat_Eme_Celular",max_length=45)
    col_dat_eme_tipo_sangre = models.CharField(db_column="Col_Dat_Eme_Tipo_Sangre",max_length=45)
    col_dat_eme_alergias = models.CharField(db_column="Col_Dat_Eme_Alergias",max_length=145)

    class Meta:
        db_table = 'col_datos_emergencia'

class ColEstatus(models.Model):
    id = models.AutoField(primary_key=True,db_column="Id")
    nombre = models.CharField(db_column="Nombre",max_length=85)

    class Meta:
        db_table = 'col_estatus'

class DatosEmpleoCol(models.Model):
    datos_empleo_col_id = models.AutoField(primary_key=True)
    fecha_ingreso = models.DateField(blank=True, null=True)
    puesto = models.ForeignKey(Puestos, models.DO_NOTHING, blank=True, null=True)
    oficina = models.ForeignKey(Oficinas, models.DO_NOTHING, blank=True, null=True)
    servicio = models.ForeignKey(Clientes, models.DO_NOTHING, blank=True, null=True)
    sucursal = models.ForeignKey(Sucursales, models.DO_NOTHING, blank=True, null=True)
    estatus = models.ForeignKey(ColEstatus, models.DO_NOTHING, blank=True, null=True)
    motivo_baja = models.CharField(max_length=200, db_collation='utf8mb4_0900_ai_ci', blank=True, null=True)
    num_cuip = models.CharField(max_length=200, db_collation='utf8mb3_general_ci', blank=True, null=True)
    num_membresia = models.CharField(max_length=10, db_collation='utf8mb3_general_ci', blank=True, null=True)
    motivo_lista_negra = models.CharField(max_length=200)
    fecha_baja = models.DateField(blank=True, null=True)
    cursos_adicionales = models.CharField(max_length=1100)
    correo_corporativo = models.CharField(max_length=200)
    nombre_jefe_inmediato = models.CharField(max_length=100)
    turno = models.CharField(max_length=100)
    #sueldo_dia = models.DecimalField(max_digits=12, decimal_places=3)
    sueldo_dia = models.CharField(max_length=100)
    tipo_pago = models.CharField(max_length=100)
    metodo_pago = models.CharField(max_length=100)
    observaciones = models.CharField(max_length=200)
    telefono_corporativo = models.CharField(max_length=100)

    # Verifica si un objeto tiene un servicio
    def tiene_servicio(self):
        tiene_servicio = False
        try:
            tiene_servicio = self.servicio is not None
        except:
            pass
        return tiene_servicio

    # Verifica si un objeto tiene una sucursal
    def tiene_sucursal(self):
        tiene_sucursal = False
        try:
            tiene_sucursal = self.sucursal is not None
        except:
            pass
        return tiene_sucursal

    class Meta:
        db_table = 'datos_empleo_col'


class DatosFiscalesCol(models.Model):
    datos_fiscales_col_id = models.AutoField(primary_key=True)
    rfc = models.CharField(max_length=100)
    domicilio_fiscal = models.CharField(max_length=400)
    entidad_federativa_fiscal = models.CharField(max_length=100)
    cp_fiscal = models.CharField(max_length=100)
    calle_numero_fiscal = models.CharField(max_length=300)
    municipio_fiscal = models.CharField(max_length=100)
    colonia_fiscal = models.CharField(max_length=100)

    clave_elector = models.CharField(max_length=150)
    num_cartilla_militar = models.CharField(max_length=100)
    num_credito_infonavit = models.CharField(max_length=150)
    num_credito_fonacot = models.CharField(max_length=150)
    clave_interbancaria = models.CharField(max_length=150)
    num_cuenta = models.CharField(max_length=150)
    num_tarjeta = models.CharField(max_length=100)
    banco = models.CharField(max_length=200)

    class Meta:
        db_table = 'datos_fiscales_col'

class Colaboradores(models.Model):
    col_id = models.AutoField(db_column='Col_Id', primary_key=True)  # Field name made lowercase.
    col_datos_fiscales = models.ForeignKey(to=DatosFiscalesCol,on_delete=models.DO_NOTHING,db_column="Col_Datos_Fiscales")
    col_datos_empleo = models.ForeignKey(to=DatosEmpleoCol,on_delete=models.DO_NOTHING,db_column="Col_Datos_Empleo")

    col_num_col = models.CharField(db_column='Col_Num_Col', max_length=20, db_collation='utf8mb3_general_ci', blank=True, null=True)  # Field name made lowercase.
    col_curp = models.CharField(db_column='Col_Curp', max_length=200, db_collation='utf8mb3_general_ci', blank=True, null=True)  # Field name made lowercase.
    col_foto_perfil = models.CharField(db_column='Col_Foto_Perfil', max_length=600, db_collation='utf8mb3_general_ci', blank=True, null=True)  # Field name made lowercase.
    col_primer_nombre = models.CharField(db_column='Col_Primer_Nombre', max_length=200, db_collation='utf8mb3_general_ci', blank=True, null=True)  # Field name made lowercase.
    col_segundo_nombre = models.CharField(db_column='Col_Segundo_Nombre', max_length=200, db_collation='utf8mb3_general_ci', blank=True, null=True)  # Field name made lowercase.
    col_apelli_paterno = models.CharField(db_column='Col_Apelli_Paterno', max_length=200, db_collation='utf8mb3_general_ci', blank=True, null=True)  # Field name made lowercase.
    col_apelli_materno = models.CharField(db_column='Col_Apelli_Materno', max_length=200, db_collation='utf8mb3_general_ci', blank=True, null=True)  # Field name made lowercase.
    col_num_imss = models.CharField(db_column='Col_Num_Imss', max_length=200, db_collation='utf8mb3_general_ci', blank=True, null=True)  # Field name made lowercase.

    col_fecha_registro = models.DateTimeField(db_column='Col_Fecha_Registro', auto_now_add=True)  # Field name made lowercase.
    # Fecha de modificacion
    col_fecha_modificacion = models.DateTimeField(auto_now=True)

    col_genero = models.CharField(db_column='Col_Genero', max_length=45, blank=True, null=True)  # Field name made lowercase.
    col_qr_id = models.CharField(db_column='Col_Qr_Id', max_length=200, blank=True, null=True)  # Field name made lowercase.
    col_qr_url = models.CharField(db_column='Col_Qr_Url', max_length=200, blank=True, null=True)  # Field name made lowercase.
    col_fecha_nacimiento = models.DateField(db_column='Col_Fecha_Nacimiento', blank=True, null=True)  # Field name made lowercase.
    col_celular_particular = models.CharField(db_column='Col_Celular_Particular', max_length=45)  # Field name made lowercase.
    col_datos_emergencia = models.ForeignKey('ColDatosEmergencia', models.DO_NOTHING, db_column='Col_Datos_Emergencia', blank=True, null=True)  # Field name made lowercase.
    col_domicilio = models.CharField(db_column='Col_Domicilio', max_length=145)  # Field name made lowercase.
    col_calle_numero = models.CharField(db_column="Col_Calle_Numero", max_length=300)
    col_municipio = models.CharField(db_column="Col_Municipio", max_length=100)


    col_edad = models.IntegerField(db_column='Col_Edad')  # Field name made lowercase.
    #col_estatura = models.FloatField(db_column='Col_Estatura')  # Field name made lowercase.
    #col_peso = models.FloatField(db_column='Col_Peso')  # Field name made lowercase.
    col_estatura = models.CharField(max_length=100, db_column="Col_Estatura")
    col_peso = models.CharField(max_length=100, db_column="Col_Peso")
    col_estado_civil = models.CharField(db_column='Col_Estado_Civil', max_length=50)  # Field name made lowercase.
    col_lugar_nacimiento = models.CharField(db_column='Col_Lugar_Nacimiento', max_length=100)  # Field name made lowercase.
    col_escolaridad = models.CharField(db_column='Col_Escolaridad', max_length=50)  # Field name made lowercase.
    col_estatus_imss = models.CharField(db_column='Col_Estatus_Imss', max_length=100)  # Field name made lowercase.
    col_fecha_alta_imss = models.DateField(db_column='Col_Fecha_Alta_Imss', null=True)  # Field name made lowercase.
    col_fecha_baja_imss = models.DateField(db_column='Col_Fecha_Baja_Imss', null=True)  # Field name made lowercase.
    col_correo_personal = models.CharField(db_column='Col_Correo_Personal', max_length=150)  # Field name made lowercase.
    col_colonia = models.CharField(db_column='Col_Colonia', max_length=100)  # Field name made lowercase.
    col_codigo_postal = models.CharField(db_column='Col_Codigo_Postal', max_length=15)  # Field name made lowercase.
    col_entidad_federativa = models.CharField(db_column="Col_Entidad_Federativa",max_length=150)
    col_talla_camisa = models.CharField(db_column='Col_Talla_Camisa', max_length=50)  # Field name made lowercase.
    col_talla_pantalon = models.CharField(db_column='Col_Talla_Pantalon', max_length=50)  # Field name made lowercase.
    col_talla_calzado = models.CharField(db_column='Col_Talla_Calzado', max_length=50)  # Field name made lowercase.
    col_tipo_licencia_conducir = models.CharField(db_column='Col_Tipo_Licencia_Conducir', max_length=50)  # Field name made lowercase.
    col_fecha_vigencia_licencia_conducir = models.DateField(db_column='Col_Fecha_Vigencia_Licencia_Conducir')  # Field name made lowercase.

    # Funcion que verifica si un objeto tiene datos fiscales
    def tiene_datos_fiscales(self):
        has_datos_fiscales = False
        try:
            has_datos_fiscales = (self.col_datos_fiscales is not None)
        except DatosFiscalesCol.DoesNotExist:
            pass
        return has_datos_fiscales

    # Funcion que verifica si un objeto tiene datos de empleo
    def tiene_datos_empleo(self):
        has_datos_empleo = False
        try:
            has_datos_empleo = (self.col_datos_empleo is not None)
        except:
            pass
        return has_datos_empleo

    # Funcion que verifica si un objeto tiene datos de emergencia
    def tiene_datos_emergencia(self):
        has_datos_emergencia = False
        try:
            has_datos_emergencia = (self.col_datos_emergencia is not None)
        except:
            pass
        return has_datos_emergencia




    class Meta:
        db_table = 'colaboradores'

class Incapacidades(models.Model):
    inc_id = models.AutoField(db_column="Inc_Id",primary_key=True)
    inc_archivo_ruta = models.CharField(db_column="Inc_Archivo_Ruta",max_length=245)
    inc_archivo_nombre = models.CharField(db_column="Inc_Archivo_Nombre",max_length=245)
    inc_fecha_inicio = models.DateField(db_column="Inc_Fecha_Inicio")
    inc_fecha_fin = models.DateField(db_column="Inc_Fecha_Fin")
    inc_colaborador = models.ForeignKey(Colaboradores,models.DO_NOTHING,db_column="Inc_Colaborador")
    inc_num_dias = models.CharField(db_column="Inc_Num_Dias", max_length=20,default="0")
    inc_fecha_registro = models.DateTimeField(auto_now_add=True, db_column="Inc_Fecha_Registro")
    inc_fecha_presentacion = models.DateField(db_column="Inc_Fecha_Presentacion")

    class Meta:
        db_table = 'incapacidades'

class Vacaciones(models.Model):
    id = models.AutoField(primary_key=True,db_column="Id")
    pagadas = models.SmallIntegerField(db_column="Pagadas")
    colaborador = models.ForeignKey(to=Colaboradores,on_delete=models.DO_NOTHING,db_column="Colaborador_Id")
    fecha_inicio = models.DateField(db_column="Fecha_Inicio")
    fecha_fin = models.DateField(db_column="Fecha_Fin")
    num_dias = models.CharField(db_column="Num_Dias", max_length=20 , default="0")
    archivo_ruta = models.CharField(db_column="Archivo_Ruta",max_length=245)
    archivo_nombre = models.CharField(db_column="Archivo_Nombre", max_length=245)
    fecha_registro = models.DateTimeField(db_column="Fecha_Registro",auto_now_add=True)
    fecha_presentacion = models.DateField(db_column="Fecha_Presentacion")

    class Meta:
        db_table = 'vacaciones'

class Cursos(models.Model):
    curso_id = models.AutoField(db_column='Curso_Id', primary_key=True)  # Field name made lowercase.
    curso_nombre = models.CharField(db_column='Curso_Nombre', max_length=200, blank=True, null=True)  # Field name made lowercase.
    curso_temas_ruta = models.CharField(db_column='Curso_Temas_Ruta',max_length=300,default="")

    class Meta:
        db_table = 'cursos'


class CursosCol(models.Model):
    curso_col_id = models.AutoField(db_column='Curso_Col_Id', primary_key=True)  # Field name made lowercase.
    curso_col_col = models.ForeignKey(Colaboradores, models.CASCADE, db_column='Curso_Col_Col_Id', blank=True, null=True)  # Field name made lowercase.
    curso_col_curso = models.ForeignKey(Cursos, models.CASCADE, db_column='Curso_Col_Curso_Id', blank=True, null=True)  # Field name made lowercase.
    curso_col_fecha = models.DateField(db_column='Curso_Col_Fecha')
    curso_col_certificado_ruta = models.CharField(db_column="Curso_Col_Certificado_Ruta",max_length=300,default="")
    curso_col_fecha_carga = models.DateTimeField(auto_now_add=True,db_column="Curso_Col_Fecha_Carga")

    class Meta:
        db_table = 'cursos_col'

class HistorialGafete(models.Model):
    historial_gafete_id = models.AutoField(primary_key=True)
    colaborador_id = models.CharField(max_length=50)
    fecha_h_gen = models.DateTimeField(auto_now_add=True)
    fecha_gen = models.DateField(auto_now_add=True)
    nombre_col = models.CharField(max_length=100)
    apellido_materno_col = models.CharField(max_length=100)
    apellido_paterno_col = models.CharField(max_length=100)
    nombre_gestor = models.CharField(max_length=100)
    email_gestor = models.CharField(max_length=100)
    curp_col = models.CharField(max_length=30)


    def tiene_gestor(self):
        tiene = False
        try:
            tiene = self.gestor is not None
        except:
            pass
        return tiene

    def tiene_col(self):
        tiene = False
        try:
            tiene = self.colaborador is not None
        except:
            pass
        return tiene

    class Meta:
        db_table = "historial_gafete"

class TipoDocCol(models.Model):
    tipo_doc_col_id = models.AutoField(primary_key=True)
    codigo = models.CharField(max_length=65)
    nombre_tipo_documento = models.CharField(max_length=100)
    nombre_carpeta = models.CharField(max_length=100)
    tipo_documento = models.CharField(max_length=45)

    class Meta:
        db_table = "tipos_docs_col"

class RegistroDocCol(models.Model):
    registro_doc_col_id = models.AutoField(primary_key=True)
    tipo_doc_col = models.ForeignKey(to=TipoDocCol,on_delete=models.CASCADE)
    col = models.ForeignKey(to=Colaboradores,on_delete=models.DO_NOTHING)
    ruta_archivo = models.CharField(max_length=245)
    fecha_carga = models.DateTimeField(auto_now_add=True)
    vigencia = models.DateField()
    observaciones = models.CharField(max_length=1000)
    no_aplica = models.BooleanField(default=False)

    class Meta:
        db_table = "registros_docs_col"
        