import logging
from django.http import JsonResponse
from django.utils.deprecation import MiddlewareMixin
from django.utils.cache import add_never_cache_headers

logger = logging.getLogger(__name__)

class JSONExceptionMiddleware(MiddlewareMixin):
    def process_exception(self, request, exception):
        # Log del error de depuracion
        logger.error("Excepción capturada: %s", str(exception), exc_info=True)

        # Verifica si la solicitud es AJAZ o proviene de 'fetch'
        if request.headers.get('x-requested-with') == "XMLHttpRequest":
            return JsonResponse(
                {"error": "Ocurrio un error interno en el servidor", "details": str(exception)},
                status=500
            )

        # Para solicitudes normales, no hacer nada (puedes dejar que Django maneje esto)
        return None


class DisableCacheMiddleware:
    def __init__(self,get_response):
        self.get_response = get_response

    def __call__(self, request):
        response = self.get_response(request)
        # Aplica las cabeceras de "never_cache"
        add_never_cache_headers(response=response)
        return response
        