# urls.py
from django.conf.urls.i18n import urlpatterns
from django.urls import path

from . import views

app_name = "reportesgc"
urlpatterns = [
  path("create-report", views.create_report, name="create_report"),
  path("modify-report",views.modify_report,name="modify_report"),
  path("save-report-section", views.save_report_section, name="save_report_section"),
  path("get-gardclean-reports", views.get_gardclean_reports, name="get_gardclean_reports"),
  path("get-all-gardclean-projects", views.get_all_gardclean_projects, name="get_all_gardclean_projects"),
  path("get-gardclean-projects-by-offices", views.get_gardclean_projects_by_offices, name="get_gardclean_projects_by_offices"),
  path("get-all-gardclean-reports-zones", views.get_all_gardclean_reports_zones,name="get_all_gardclean_reports_zones"),
  path("get-gardclean-reports-zones-by-client",views.get_gardclean_reports_zones_by_client, name="get_gardclean_reports_zones_by_client"),
  path("get-sections-by-gardclean-report", views.get_sections_by_gardclean_report, name="get_sections_by_gardclean_report"),
  path("save-report-section-changes", views.save_report_section_changes, name="save_report_sections_changes"),
  path("get-evidence-images-by-gardclean-report-section", views.get_evidence_images_by_section, name="get_evidence_images_by_gardcleam_report_section"),
  path("get-gardclean-reports-by-project", views.get_gardclean_reports_by_project, name="get_gardclean_reports_by_project"),
  path("get-gardclean-report-by-id", views.get_gardclean_report_by_id, name="get_gardclean_report_by_id"),
  path("delete-gardclean-report", views.delete_gardclean_report,name="delete_gardclean_report"),

  path("generate-report-pdf",views.generate_report_pdf,name="generate_report_pdf"),

  path("test", views.test, name="test")
]
