import bcrypt
# Clase criptografica que usa la función de hashing de contraseñas BCRYPT
class Bcrypt:
    # Metodo que encripta un texto plano a un hash
    @staticmethod
    def encrypt(plain_text: str) -> str:
        bytePwd = plain_text.encode('utf-8')
        # Genera un salt aleatorio
        mySalt = bcrypt.gensalt()
        # Hashea la contraseña
        pwd_hash = bcrypt.hashpw(bytePwd,mySalt)
        # Decodifica el hash generado
        pwd_hash = pwd_hash.decode('utf-8')
        return pwd_hash
    # Metodo que verifica si un hash y un texto plano son iguales
    @staticmethod
    def verify(plain_text,hash) -> bool:
        return bcrypt.checkpw(plain_text.encode('utf-8'),hash.encode('utf-8'))